<?php
require_once __DIR__ . '/../models/auth/Token.php';

class ApiController {
    private $tokenModel;

    public function __construct() {
        $this->tokenModel = new Token();
    }

    // Procesa la solicitud entrante
    public function processRequest() {
        // Obtener token del header "Authorization"
        $headers = $this->getAuthorizationHeader();
        $token = isset($headers["Authorization"]) ? trim($headers["Authorization"]) : null;

        if (!$token) {
            http_response_code(401);
            echo json_encode(["error" => "Token no proporcionado"]);
            exit();
        }

        // Validar si el token existe en la BD
        if (!$this->tokenModel->exists($token)) {
            http_response_code(403);
            echo json_encode(["error" => "Token inválido"]);
            exit();
        }

        // Si llega aquí, el token es válido.
        // Se puede continuar con el procesamiento de otros endpoints.
        echo json_encode(["message" => "Token válido, acceso permitido."]);
    }
    
    

    // Función para obtener el header Authorization
    private function getAuthorizationHeader() {
        $headers = [];
        // En servidores Apache se puede usar apache_request_headers()
        if (function_exists('apache_request_headers')) {
            $headers = apache_request_headers();
        } else {
            // Método alternativo
            foreach ($_SERVER as $key => $value) {
                if (substr($key, 0, 5) == "HTTP_") {
                    $header = str_replace(" ", "-", ucwords(str_replace("_", " ", strtolower(substr($key, 5)))));
                    $headers[$header] = $value;
                }
            }
        }
        return $headers;
    }
  
    
    
}
